import sys, pygame, math, numpy, random, time, copy
from pygame.locals import *

from constants import *
from utils import *
from core import *
from moba import *

#############################
### MyHero

class MyHero(Hero):

	def __init__(self, position, orientation, world, image = AGENT, speed = SPEED, viewangle = 360, hitpoints = HEROHITPOINTS, firerate = FIRERATE, bulletclass = BigBullet, dodgerate = DODGERATE, areaeffectrate = AREAEFFECTRATE, areaeffectdamage = AREAEFFECTDAMAGE):
		Hero.__init__(self, position, orientation, world, image, speed, viewangle, hitpoints, firerate, bulletclass, dodgerate, areaeffectrate, areaeffectdamage)
		self.states = [Idle]
		### Add your states to self.states (but don't remove Idle)
		### YOUR CODE GOES BELOW HERE ###
                self.states = self.states + [Posse,FullRetreat,CombatMode, Farm, Restore, Pursue, Hunt]
		### YOUR CODE GOES ABOVE HERE ###

	def start(self):
		Hero.start(self)
		self.changeState(Idle)

############################
### Idle
###
### This is the default state of MyHero. The main purpose of the Idle state is to figure out what state to change to and do that immediately.

class Idle(State):
	
	def enter(self, oldstate):
		State.enter(self, oldstate)
		# stop moving
		self.agent.stopMoving()
	
	def execute(self, delta = 0):
		State.execute(self, delta)
		### YOUR CODE GOES BELOW HERE ###
                self.agent.changeState(Posse)
		### YOUR CODE GOES ABOVE HERE ###
		return None

###############################
### YOUR STATE CLASSES GO HERE:
### Posse
###
### Hang around most amount of minions possible

class Posse(State):

        def enter(self, oldstate):
                self.prevPosseMember = None
                self.leash = 50
                # Solve for Posse
                self.teamMinions = []
                self.posse = []
                for m in self.agent.world.getNPCsForTeam(self.agent.getTeam()):
                        # and distance(m.getLocation(),self.agent.world.getBaseForTeam(self.agent.getTeam()).getLocation())>50 and distance(m.getLocation(),self.agent.getLocation())<10:
                        if m not in self.agent.world.getTowers() and m not in self.agent.world.getBases() and m.alive and m != self.agent :
                                if self.agent.world.getEnemyBases(self.agent.getTeam()):
                                        if distance(m.getLocation(),self.agent.world.getEnemyBases(self.agent.getTeam())[0].getLocation()) > 2*BASEBULLETRANGE:
                                                self.teamMinions.append(m)
                                else:
                                        self.teamMinions.append(m)

                if self.teamMinions:
                        for m in self.teamMinions:
                                for n in self.teamMinions:
                                        if n != m and (n not in self.posse or m not in self.posse):
                                                if distance(n.getLocation(),m.getLocation()) < 30:
                                                        self.posse.append(m)
                                                        self.posse.append(n)
                if self.posse == [] and self.teamMinions:
                        dist = -1
                        self.posse.append(None)
                        for m in self.teamMinions:
                                if dist == -1 or distance(self.agent.getLocation(),m.getLocation()) < distance:
                                        dist = distance(self.agent.getLocation(),m.getLocation())
                                        self.posse[0] = m

                if self.posse != []:
                        if distance(self.posse[0].getLocation(),self.agent.getLocation()) < self.leash and self.agent.moveTarget is None:
                                self.agent.navigateTo(self.posse[0].getLocation())
                                        
                                
                                

        def execute(self, delta = 0):
                if self.agent.getHitpoints() < self.agent.getMaxHitpoints()/2:
                        self.agent.changeState(FullRetreat)
                        return None
                
                evil = self.agent.world.getEnemyNPCs(self.agent.getTeam())
                highestHealth = 0
                lowestHealth = 50
                evilTarget = None
                weakEvilTarget = None
                for e in evil:
                        if e not in self.agent.world.getEnemyTowers(self.agent.getTeam()) and e not in self.agent.world.getEnemyBases(self.agent.getTeam()):
                                if e.getMaxHitpoints()>highestHealth:
                                        highestHealth = e.getMaxHitpoints()
                                        evilTarget = e

                                if e.getHitpoints()<lowestHealth:
                                        lowestHealth = e.getHitpoints()
                                        weakEvilTarget = e

                '''print self.agent.getMaxHitpoints(), " vs: ", highestHealth'''
                if evilTarget:
                        if highestHealth < self.agent.getMaxHitpoints() and self.agent.getHitpoints() > evilTarget.getHitpoints():
                                self.agent.changeState(Hunt,evilTarget)
                                return None
                        elif self.agent.getHitpoints() == self.agent.getMaxHitpoints():
                                self.agent.changeState(Hunt,weakEvilTarget)
                                return None
                
                self.leash = 50
                # Solve for Posse
                self.teamMinions = []
                self.posse = [None]

                # find all the possible team mates
                for m in self.agent.world.getNPCsForTeam(self.agent.getTeam()):
                        if m not in self.agent.world.getTowers() and m not in self.agent.world.getBases() and m.alive and m != self.agent and distance(m.getLocation(),self.agent.world.getEnemyBases(self.agent.getTeam())[0].getLocation()) > 2*BASEBULLETRANGE:
                                if distance(m.getLocation(),self.agent.world.getBaseForTeam(self.agent.getTeam()).getLocation()) > BASEBULLETRANGE:
                                        if m.moveTarget is not None:
                                                if distance(m.moveTarget,self.agent.world.getEnemyBases(self.agent.getTeam())[0].getLocation()) > 2*BASEBULLETRANGE:
                                                        self.teamMinions.append(m)
                                        else:
                                                self.teamMinions.append(m)
                        

                if self.teamMinions:
                        # Prioritize fighting friendlies
                        for m in self.teamMinions:
                                if m.moveTarget == None:
                                        self.posse[0] = m
                                        
                        # Prioritize groups of friendlies
                        for m in self.teamMinions:
                                for n in self.teamMinions:
                                        if n != m and (n not in self.posse or m not in self.posse):
                                                if distance(n.getLocation(),m.getLocation()) < 30:
                                                        self.posse.append(m)
                                                        self.posse.append(n)

                # Follow the closest teammate if no posse members found
                if (self.posse == [] or self.posse == [None]) and self.teamMinions:
                        dist = -1
                        self.posse.append(None)
                        for m in self.teamMinions:
                                if dist == -1 or distance(self.agent.getLocation(),m.getLocation()) < distance:
                                        dist = distance(self.agent.getLocation(),m.getLocation())
                                        self.posse[0] = m

                # Posse not gone or dead
                if (self.posse != [] or self.posse != [None]) and self.posse[0] is not None:
                        '''print "all good in the posse: ", self.agent.world.getScore(self.agent.getTeam()), " vs ", self.agent.world.getScore(2)'''
                        # if following dead guy
                        if self.posse[0].alive is False:
                                self.agent.changeState(Posse)
                                return None

                        # if previously followed friendly dies
                        if self.prevPosseMember is not None:
                                if self.prevPosseMember.alive is False:
                                        self.agent.changeState(Posse)
                                        return None
                                
                        # if (outside posse range && not moving)  || (new Posse leader)
                        if (distance(self.posse[0].getLocation(),self.agent.getLocation()) > self.leash and self.agent.moveTarget is None) or self.posse[0] != self.prevPosseMember:
                                if self.posse[0].moveTarget is not None:
                                        # don't follow any member who plans on moving to or is anywhere near the enemy base
                                                
                                        if distance(self.posse[0].getLocation(),self.agent.world.getEnemyBases(self.agent.getTeam())[0].getLocation()) > 2*BASEBULLETRANGE and distance(self.posse[0].moveTarget,self.agent.world.getEnemyBases(self.agent.getTeam())[0].getLocation()) > 2*BASEBULLETRANGE:
                                                self.agent.navigateTo(self.posse[0].getLocation())
                                else:
                                        self.agent.navigateTo(self.posse[0].getLocation())
                                self.prevPosseMember = self.posse[0]

                        # if stopped and outside leash range
                        if self.posse[0].moveTarget == None and distance(self.agent.getLocation(), self.posse[0].getLocation()) < self.leash:
                                self.agent.changeState(CombatMode)
                                return None

                for b in self.agent.getVisible():
                        if b in self.agent.world.getBullets():
                                if b.getOwner().getTeam() != self.agent.getTeam():
                                        self.agent.changeState(Farm)
                                        return None

                # catch all if stuck not moving
                if self.agent.moveTarget is None:
                        moveTo = None
                        dist = -1
                        for m in self.teamMinions:
                                if m != self.posse[0]:
                                        if dist == -1 or distance(self.agent.getLocation(),m.getLocation()) < distance:
                                                dist = distance(self.agent.getLocation(),m.getLocation())
                                                moveTo = m
                        if moveTo is None:
                                self.agent.changeState(Posse)
                                return None
                        elif True:
                                #default to retreat if stuck
                                self.agent.navigateTo(m.getLocation())


### FullRetreat
###
### Duck behind the nearest friendly NPC then high tail it to base
class FullRetreat(State):
        def enter(self, oldstate):
                self.hazardousBullets = []
                self.teamMinions = []
                self.homeBase = self.agent.world.getBaseForTeam(self.agent.getTeam())
                self.humanShieldLocation = None

                # find every friendly npc that closer to you than the base on the way to retreating to base
                for m in self.agent.world.getNPCsForTeam(self.agent.getTeam()):
                        if m not in self.agent.world.getTowers() and m not in self.agent.world.getBases() and m.alive:
                                self.teamMinions.append(m)

        def execute(self, delta = 0):
                self.combatants = []

                for m in self.agent.getVisible():                                               
                        if m in self.agent.world.getEnemyNPCs(self.agent.getTeam()) and m not in self.agent.world.getBases() and m not in self.agent.world.getTowers()and m.alive is True:
                                        self.combatants.append(m)

                for m in self.combatants:
                        if distance(self.agent.getLocation(),m.getLocation())< self.agent.getRadius()*AREAEFFECTRANGE:
                                self.agent.areaEffect()
                # once arrived at friendly npc, navigate to base

                if self.agent.moveTarget is None:
                        self.agent.navigateTo(self.homeBase.getLocation())  

                if distance(self.agent.getLocation(),self.homeBase.getLocation()) < 20:
                        self.agent.changeState(Restore)
                        return None



                if self.agent.moveTarget is None:
                        self.agent.navigateTo(self.homeBase.getLocation())

                                         
                # bullet dodging
                if self.agent.canDodge:
                        for b in self.agent.getVisible():
                                if b in self.agent.world.getBullets():
                                        if b.getOwner().getTeam() != self.agent.getTeam():
                                                
                                                if b not in self.hazardousBullets:
                                                        agentLocX, agentLocY = self.agent.getLocation()
                                                        
                                                        bulletLocX, bulletLocY = b.getLocation()

                
                                                        bulletOrientationVector = (math.cos(math.radians(b.orientation)),math.sin(math.radians(b.orientation)))

                                                        bulletSpeedX, bulletSpeedY = bulletOrientationVector
                                                        bulletTrajectoryX = b.range*bulletSpeedX
                                                        bulletTrajectoryY = -b.range*bulletSpeedY
                                                        agentHitboxPlane = (-bulletTrajectoryY,bulletTrajectoryX)
                                                        negAgentHitboxPlane = (bulletTrajectoryY, - bulletTrajectoryX)
                                                        
                                                        bulletIntersection = rayTrace(b.getLocation(),(bulletLocX+bulletTrajectoryX,bulletLocY+bulletTrajectoryY),((agentLocX-bulletTrajectoryY,agentLocY+bulletTrajectoryX),(agentLocX+bulletTrajectoryY,agentLocY-bulletTrajectoryX)))

                                                        if bulletIntersection:
                                                                self.hazardousBullets.append(b)
                                                                if distance(bulletIntersection,self.agent.getLocation()) < 10:
                                                                        #dodge along (agentLocX+bulletTrajectoryY,agentLocY-bulletTrajectoryX)) or (agentLocX-bulletTrajectoryY,agentLocY+bulletTrajectoryX))
                                                                        if rayTraceWorld(self.agent.getLocation(),(agentLocX+(self.agent.getRadius()*6*bulletSpeedY),agentLocY-(self.agent.getRadius()*6*(-bulletSpeedX))),self.agent.world.getLines()) is None:
                                                                                self.agent.dodge(math.atan2(-bulletSpeedX,bulletSpeedY)*(180/math.pi))
                                                                        elif rayTraceWorld(self.agent.getLocation(),(agentLocX-(self.agent.getRadius()*6*bulletSpeedY),agentLocY+(self.agent.getRadius()*6*(-bulletSpeedX))),self.agent.world.getLines()) is None:
                                                                                self.agent.dodge(math.atan2(bulletSpeedX,-bulletSpeedY)*(180/math.pi))



                if self.agent.canDodge and self.agent.moveTarget:
                        agentX, agentY = self.agent.getLocation()
                        targetX, targetY = self.agent.moveTarget
                        self.agent.dodge(math.atan2(-1*(targetY-agentY), 1*(targetX-agentX))*(180/math.pi))

### Retreat
###
### Find a new partner and resume leveling


### Hunt
class Hunt(State):

	def parseArgs(self, args):
		self.victim = args[0]

        def enter(self,oldstate):
                self.range = BIGBULLETRANGE-5
                self.combatants = []
                self.hazardousBullets = []

                for m in self.agent.getVisible():                                               
                        if m in self.agent.world.getEnemyNPCs(self.agent.getTeam()) and m not in self.agent.world.getBases() and m not in self.agent.world.getTowers() and m.alive is True:
                                if m.moveTarget is None and m not in self.combatants:
                                        self.combatants.append(m)
                

                if len(self.combatants)>0 :
                        if self.combatants[0].getLocation()!= self.victim.getLocation() or len(self.combatants)>1:
                                if self.combatants[0].getLocation()!=self.victim.getLocation():
                                        self.agent.changeState(Pursue,self.combatants[0])
                                return None

                
        def execute(self,delta=0):
                self.combatants = []
                
                for m in self.agent.getVisible():                                               
                        if m in self.agent.world.getEnemyNPCs(self.agent.getTeam()) and m not in self.agent.world.getBases() and m not in self.agent.world.getTowers()and m.alive is True:
                                if m.moveTarget is None and m not in self.combatants:
                                        if m.getLocation()!= self.victim.getLocation():
                                                self.agent.changeState(Pursue,m)
                                                return None

                if len(self.combatants)>0 :
                        if self.combatants[0].getLocation()!= self.victim.getLocation() or len(self.combatants)>1:
                                if self.combatants[0].getLocation()!=self.victim.getLocation():
                                        self.agent.changeState(Pursue,self.combatants[0])
                                return None
                        
                elif self.victim:
                        if self.victim.alive :
                                if distance(self.agent.getLocation(),self.victim.getLocation()) < self.range :
                                        if self.victim.isMoving():
                                                if self.agent.world.getEnemyBases(self.agent.getTeam())[0]:
                                                        if distance(self.victim.getLocation(),self.agent.world.getEnemyBases(self.agent.getTeam())[0].getLocation()) > 150:
                                                                self.agent.navigateTo(self.victim.moveTarget)

                                                        else:
                                                                if(self.agent.hitpoints < self.agent.getMaxHitpoints()/2):
                                                                        self.agent.changeState(FullRetreat)
                                                                else:
                                                                        self.agent.changeState(Posse)
                                                                return None
                                                else:
                                                        self.agent.navigateTo(self.victim.moveTarget)
 
                                        else:
                                                self.agent.changeState(Farm)
                                                return None
                                elif self.agent.world.getEnemyBases(self.agent.getTeam())[0]:
                                        if distance(self.victim.getLocation(),self.agent.world.getEnemyBases(self.agent.getTeam())[0].getLocation()) > 150:
                                                if self.victim.moveTarget and distance(self.victim.moveTarget,self.agent.getLocation())>10:
                                                        if self.agent.moveTarget != self.victim.moveTarget:
                                                                self.agent.navigateTo(self.victim.moveTarget)
                                                else:
                                                        if self.agent.moveTarget != self.victim.getLocation():
                                                                self.agent.navigateTo(self.victim.getLocation())
                                        else:
                                                if(self.agent.hitpoints < self.agent.getMaxHitpoints()/2):
                                                        self.agent.changeState(FullRetreat)
                                                else:
                                                        self.agent.changeState(Posse)
                                                return None
                                else:
                                        if self.victim.moveTarget:
                                                self.agent.navigateTo(self.victim.moveTarget)
                                        else:
                                                self.agent.navigateTo(self.victim.getLocation())
                        else:
                                if(self.agent.hitpoints < self.agent.getMaxHitpoints()/2):
                                        self.agent.changeState(FullRetreat)
                                else:
                                        self.agent.changeState(Posse)
                                return None
                else:
                        if(self.agent.hitpoints < self.agent.getMaxHitpoints()/2):
                                self.agent.changeState(FullRetreat)
                        else:
                                self.agent.changeState(Posse)
                        return None

                if self.victim.isMoving():
                        targetX, targetY = self.victim.getLocation()
                        direction = [m - n for m,n in zip(self.victim.moveTarget,self.victim.getLocation())]
                        bulletDirection = [m - n for m,n in zip(self.victim.getLocation(),self.agent.getLocation())]
                        mag = distance(self.victim.getLocation(), self.victim.moveTarget)
                        bulletMag = distance(self.agent.getLocation(), self.victim.getLocation())

                        normalizedDirection = [x/mag for x in direction]
                        next = [m*n for m,n in zip(normalizedDirection,self.victim.speed)]
                        nextX, nextY = next

                        bulletTime = bulletMag/20
                                                
                        self.agent.turnToFace((targetX+ (bulletTime* nextX),targetY+(bulletTime*nextY)))
                else:
                        self.agent.turnToFace(self.victim.getLocation())

                self.agent.shoot()

                if self.agent.canDodge:
                        for b in self.agent.getVisible():
                                if b in self.agent.world.getBullets():
                                        if b.getOwner().getTeam() != self.agent.getTeam():
                                                
                                                if b not in self.hazardousBullets:
                                                        agentLocX, agentLocY = self.agent.getLocation()
                                                        
                                                        bulletLocX, bulletLocY = b.getLocation()

                
                                                        bulletOrientationVector = (math.cos(math.radians(b.orientation)),math.sin(math.radians(b.orientation)))

                                                        bulletSpeedX, bulletSpeedY = bulletOrientationVector
                                                        bulletTrajectoryX = b.range*bulletSpeedX
                                                        bulletTrajectoryY = -b.range*bulletSpeedY
                                                        agentHitboxPlane = (-bulletTrajectoryY,bulletTrajectoryX)
                                                        negAgentHitboxPlane = (bulletTrajectoryY, - bulletTrajectoryX)
                                                        
                                                        bulletIntersection = rayTrace(b.getLocation(),(bulletLocX+bulletTrajectoryX,bulletLocY+bulletTrajectoryY),((agentLocX-bulletTrajectoryY,agentLocY+bulletTrajectoryX),(agentLocX+bulletTrajectoryY,agentLocY-bulletTrajectoryX)))



                                                        if bulletIntersection:
                                                                self.hazardousBullets.append(b)
                                                                if distance(bulletIntersection,self.agent.getLocation()) < 10:
                                                                        #dodge along (agentLocX+bulletTrajectoryY,agentLocY-bulletTrajectoryX)) or (agentLocX-bulletTrajectoryY,agentLocY+bulletTrajectoryX))
                                                                        if rayTraceWorld(self.agent.getLocation(),(agentLocX+(self.agent.getRadius()*6*bulletSpeedY),agentLocY-(self.agent.getRadius()*6*(-bulletSpeedX))),self.agent.world.getLines()) is None:
                                                                                self.agent.dodge(math.atan2(-bulletSpeedX,bulletSpeedY)*(180/math.pi))
                                                                        elif rayTraceWorld(self.agent.getLocation(),(agentLocX-(self.agent.getRadius()*6*bulletSpeedY),agentLocY+(self.agent.getRadius()*6*(-bulletSpeedX))),self.agent.world.getLines()) is None:
                                                                                self.agent.dodge(math.atan2(bulletSpeedX,-bulletSpeedY)*(180/math.pi))





### Pursue
###
### Once requirements are met, seek to engage in favorable conditions
class Pursue(State):

	def parseArgs(self, args):
		self.victim = args[0]

        def enter(self,oldstate):
                self.range = BIGBULLETRANGE-5
                self.combatants = []
                self.hazardousBullets = []

                for m in self.agent.getVisible():                                               
                        if m in self.agent.world.getEnemyNPCs(self.agent.getTeam()) and m not in self.agent.world.getBases() and m not in self.agent.world.getTowers() and m.alive is True:
                                if m.moveTarget is None and m not in self.combatants:
                                        self.combatants.append(m)
                

                if len(self.combatants)>0 :
                        if self.combatants[0]!= self.victim or len(self.combatants)>1:
                                self.agent.changeState(FullRetreat)
                                return None

                
        def execute(self,delta=0):
                self.combatants = []
                
                for m in self.agent.getVisible():                                               
                        if m in self.agent.world.getEnemyNPCs(self.agent.getTeam()) and m not in self.agent.world.getBases() and m not in self.agent.world.getTowers()and m.alive is True:
                                if m.moveTarget is None and m not in self.combatants:
                                        if m.getLocation()!= self.victim.getLocation():
                                                self.agent.changeState(FullRetreat)
                                                return None

                if len(self.combatants)>0 :
                        if self.combatants[0].getLocation()!= self.victim.getLocation() or len(self.combatants)>1:
                                self.agent.changeState(FullRetreat)
                                return None
                        
                elif self.victim:
                        if self.victim.alive :
                                if distance(self.agent.getLocation(),self.victim.getLocation()) < self.range :
                                        if self.victim.isMoving():
                                                if self.agent.world.getEnemyBases(self.agent.getTeam())[0]:
                                                        if distance(self.victim.getLocation(),self.agent.world.getEnemyBases(self.agent.getTeam())[0].getLocation()) > 150:
                                                                self.agent.navigateTo(self.victim.moveTarget)

                                                        else:
                                                                if(self.agent.hitpoints < self.agent.getMaxHitpoints()/2):
                                                                        self.agent.changeState(FullRetreat)
                                                                else:
                                                                        self.agent.changeState(Posse)
                                                                return None
                                                else:
                                                        self.agent.navigateTo(self.victim.moveTarget)
 
                                        else:
                                                self.agent.changeState(Farm)
                                                return None
                                elif self.agent.world.getEnemyBases(self.agent.getTeam())[0]:
                                        if distance(self.victim.getLocation(),self.agent.world.getEnemyBases(self.agent.getTeam())[0].getLocation()) > 150:
                                                if self.victim.moveTarget:
                                                        self.agent.navigateTo(self.victim.moveTarget)
                                                else:
                                                        self.agent.navigateTo(self.victim.getLocation())
                                        else:
                                                if(self.agent.hitpoints < self.agent.getMaxHitpoints()/2):
                                                        self.agent.changeState(FullRetreat)
                                                else:
                                                        self.agent.changeState(Posse)
                                                return None
                                else:
                                        if self.victim.moveTarget:
                                                self.agent.navigateTo(self.victim.moveTarget)
                                        else:
                                                self.agent.navigateTo(self.victim.getLocation())
                        else:
                                if(self.agent.hitpoints < self.agent.getMaxHitpoints()/2):
                                        self.agent.changeState(FullRetreat)
                                else:
                                        self.agent.changeState(Posse)
                                return None
                else:
                        if(self.agent.hitpoints < self.agent.getMaxHitpoints()/2):
                                self.agent.changeState(FullRetreat)
                        else:
                                self.agent.changeState(Posse)
                        return None

                if self.victim.isMoving():
                        targetX, targetY = self.victim.getLocation()
                        direction = [m - n for m,n in zip(self.victim.moveTarget,self.victim.getLocation())]
                        bulletDirection = [m - n for m,n in zip(self.victim.getLocation(),self.agent.getLocation())]
                        mag = distance(self.victim.getLocation(), self.victim.moveTarget)
                        bulletMag = distance(self.agent.getLocation(), self.victim.getLocation())

                        normalizedDirection = [x/mag for x in direction]
                        next = [m*n for m,n in zip(normalizedDirection,self.victim.speed)]
                        nextX, nextY = next

                        bulletTime = bulletMag/20
                                                
                        self.agent.turnToFace((targetX+ (bulletTime* nextX),targetY+(bulletTime*nextY)))
                else:
                        self.agent.turnToFace(self.victim.getLocation())

                self.agent.shoot()

                if self.agent.canDodge:
                        for b in self.agent.getVisible():
                                if b in self.agent.world.getBullets():
                                        if b.getOwner().getTeam() != self.agent.getTeam():
                                                
                                                if b not in self.hazardousBullets:
                                                        agentLocX, agentLocY = self.agent.getLocation()
                                                        
                                                        bulletLocX, bulletLocY = b.getLocation()

                
                                                        bulletOrientationVector = (math.cos(math.radians(b.orientation)),math.sin(math.radians(b.orientation)))

                                                        bulletSpeedX, bulletSpeedY = bulletOrientationVector
                                                        bulletTrajectoryX = b.range*bulletSpeedX
                                                        bulletTrajectoryY = -b.range*bulletSpeedY
                                                        agentHitboxPlane = (-bulletTrajectoryY,bulletTrajectoryX)
                                                        negAgentHitboxPlane = (bulletTrajectoryY, - bulletTrajectoryX)
                                                        
                                                        bulletIntersection = rayTrace(b.getLocation(),(bulletLocX+bulletTrajectoryX,bulletLocY+bulletTrajectoryY),((agentLocX-bulletTrajectoryY,agentLocY+bulletTrajectoryX),(agentLocX+bulletTrajectoryY,agentLocY-bulletTrajectoryX)))



                                                        if bulletIntersection:
                                                                self.hazardousBullets.append(b)
                                                                if distance(bulletIntersection,self.agent.getLocation()) < 10:
                                                                        #dodge along (agentLocX+bulletTrajectoryY,agentLocY-bulletTrajectoryX)) or (agentLocX-bulletTrajectoryY,agentLocY+bulletTrajectoryX))
                                                                        if rayTraceWorld(self.agent.getLocation(),(agentLocX+(self.agent.getRadius()*6*bulletSpeedY),agentLocY-(self.agent.getRadius()*6*(-bulletSpeedX))),self.agent.world.getLines()) is None:
                                                                                self.agent.dodge(math.atan2(-bulletSpeedX,bulletSpeedY)*(180/math.pi))
                                                                        elif rayTraceWorld(self.agent.getLocation(),(agentLocX-(self.agent.getRadius()*6*bulletSpeedY),agentLocY+(self.agent.getRadius()*6*(-bulletSpeedX))),self.agent.world.getLines()) is None:
                                                                                self.agent.dodge(math.atan2(bulletSpeedX,-bulletSpeedY)*(180/math.pi))



### Farm
###
### Fighting alone, highly dangerous
class Farm(State):
        
        def enter(self,oldstate):
                self.range = BIGBULLETRANGE
                self.combatants = []
                self.combatTarget = None
                self.hazardousBullets = []

                for m in self.agent.getVisible():                                               
                        if m in self.agent.world.getEnemyNPCs(self.agent.getTeam()) and m not in self.agent.world.getBases() and m not in self.agent.world.getTowers() and m.alive is True:
                                if m.moveTarget is None and m not in self.combatants:
                                        self.combatants.append(m)

                for c in self.combatants:
                        lowestHitpoints = -1
                        if lowestHitpoints == -1 or c.getHitpoints() < lowestHitpoints:
                                lowestHitpoints = c.getHitpoints()
                                self.combatTarget = c
                
                if len(self.combatants)> 1:
                        self.agent.changeState(FullRetreat)
                        return None

                self.agent.stopMoving()

        def execute(self, delta = 0):
                self.combatants = []
                for m in self.agent.getVisible():                                               
                        if m in self.agent.world.getEnemyNPCs(self.agent.getTeam()) and m not in self.agent.world.getBases() and m not in self.agent.world.getTowers()and m.alive is True:
                                if m.moveTarget is None and m not in self.combatants:
                                        self.combatants.append(m)

                if len(self.combatants)> 1:
                        self.agent.changeState(FullRetreat)
                        return None

                # if combatTarget is still valid
                if self.combatTarget:
                        if self.combatTarget.alive is True:                              # Does the target qualify to be shot
                                if distance(self.agent.getLocation(),self.combatTarget.getLocation()) < self.range :
                                        self.agent.stopMoving()
                                        if(self.combatTarget.isMoving()):
                                                targetX, targetY = self.combatTarget.getLocation()
                                                direction = [m - n for m,n in zip(self.combatTarget.moveTarget,self.combatTarget.getLocation())]
                                                bulletDirection = [m - n for m,n in zip(self.combatTarget.getLocation(),self.agent.getLocation())]
                                                mag = distance(self.combatTarget.getLocation(), self.combatTarget.moveTarget)
                                                bulletMag = distance(self.agent.getLocation(), self.combatTarget.getLocation())

                                                normalizedDirection = [x/mag for x in direction]
                                                next = [m*n for m,n in zip(normalizedDirection,self.combatTarget.speed)]
                                                nextX, nextY = next

                                                bulletTime = bulletMag/20
                                                
                                                self.agent.turnToFace((targetX+ (bulletTime* nextX),targetY+(bulletTime*nextY)))
                                        else:
                                                self.agent.turnToFace(self.combatTarget.getLocation())

                                        self.agent.shoot()
                                else:
                                        self.agent.changeState(Pursue,self.combatTarget)
                                        return None
                        else :                                                          # if target is dead
                                if(self.agent.hitpoints < self.agent.getMaxHitpoints()/2):
                                        self.agent.changeState(FullRetreat)
                                else:
                                        self.agent.changeState(Posse)
                                return None

                else:
                        if(self.agent.hitpoints < self.agent.getMaxHitpoints()/2):
                                self.agent.changeState(FullRetreat)
                        else:
                                self.agent.changeState(Posse)
                        return None


                if self.agent.canDodge:
                        for b in self.agent.getVisible():
                                if b in self.agent.world.getBullets():
                                        if b.getOwner().getTeam() != self.agent.getTeam():
                                                
                                                if b not in self.hazardousBullets:
                                                        agentLocX, agentLocY = self.agent.getLocation()
                                                        
                                                        bulletLocX, bulletLocY = b.getLocation()

                
                                                        bulletOrientationVector = (math.cos(math.radians(b.orientation)),math.sin(math.radians(b.orientation)))

                                                        bulletSpeedX, bulletSpeedY = bulletOrientationVector
                                                        bulletTrajectoryX = b.range*bulletSpeedX
                                                        bulletTrajectoryY = -b.range*bulletSpeedY
                                                        agentHitboxPlane = (-bulletTrajectoryY,bulletTrajectoryX)
                                                        negAgentHitboxPlane = (bulletTrajectoryY, - bulletTrajectoryX)
                                                        
                                                        bulletIntersection = rayTrace(b.getLocation(),(bulletLocX+bulletTrajectoryX,bulletLocY+bulletTrajectoryY),((agentLocX-bulletTrajectoryY,agentLocY+bulletTrajectoryX),(agentLocX+bulletTrajectoryY,agentLocY-bulletTrajectoryX)))


                                                        if bulletIntersection:
                                                                self.hazardousBullets.append(b)
                                                                if distance(bulletIntersection,self.agent.getLocation()) < 10:
                                                                        #dodge along (agentLocX+bulletTrajectoryY,agentLocY-bulletTrajectoryX)) or (agentLocX-bulletTrajectoryY,agentLocY+bulletTrajectoryX))
                                                                        if rayTraceWorld(self.agent.getLocation(),(agentLocX+(self.agent.getRadius()*6*bulletSpeedY),agentLocY-(self.agent.getRadius()*6*(-bulletSpeedX))),self.agent.world.getLines()) is None:
                                                                                self.agent.dodge(math.atan2(-bulletSpeedX,bulletSpeedY)*(180/math.pi))
                                                                        elif rayTraceWorld(self.agent.getLocation(),(agentLocX-(self.agent.getRadius()*6*bulletSpeedY),agentLocY+(self.agent.getRadius()*6*(-bulletSpeedX))),self.agent.world.getLines()) is None:
                                                                                self.agent.dodge(math.atan2(bulletSpeedX,-bulletSpeedY)*(180/math.pi))

                                                                        
                                                                


### Combat Mode
###
### Minimize risk, stay alert to prepare for retreat
class CombatMode(State):

        def enter(self,oldstate):
                self.hazardousBullets = []
                self.range = BIGBULLETRANGE
                self.combatants = []
                self.combatTarget = None

                self.comrades = []                                                              # get friendlies
                for m in self.agent.getVisible():
                        if m in self.agent.world.getNPCsForTeam(self.agent.getTeam()) and m != self.agent and m not in self.agent.world.getBases() and m not in self.agent.world.getTowers() and m.alive is True and m.moveTarget is None:
                                self.comrades.append(m)
                                                                                                # get enemies                                                                              
                for m in self.agent.getVisible():                                               
                        if m in self.agent.world.getEnemyNPCs(self.agent.getTeam()) and distance(self.agent.getLocation(),m.getLocation()) < self.range and m not in self.agent.world.getBases() and m not in self.agent.world.getTowers():
                                self.combatants.append(m)

                for c in self.combatants:
                        lowestHitpoints = -1
                        if lowestHitpoints == -1 or c.getHitpoints() < lowestHitpoints:
                                lowestHitpoints = c.getHitpoints()
                                self.combatTarget = c

                self.agent.stopMoving()
                        
        def execute(self, delta = 0):
                fight = False


                # check if comrades are fighting
                if self.comrades == []:
                        self.agent.changeState(Posse)
                        return None
                else :
                        for f in self.comrades:
                                if f.alive and f.moveTarget == None:
                                        fight = True
                                        
                # if no one is fighting or all dead
                if fight == False:
                        self.agent.changeState(Posse)
                        return None


                # if combatTarget is still valid
                if self.combatTarget:
                        if self.combatTarget is not None:
                                if self.combatTarget.alive is True:                              # Does the target qualify to be shot
                                        if(self.combatTarget.isMoving()):
                                                targetX, targetY = self.combatTarget.getLocation()
                                                direction = [m - n for m,n in zip(self.combatTarget.moveTarget,self.combatTarget.getLocation())]
                                                bulletDirection = [m - n for m,n in zip(self.combatTarget.getLocation(),self.agent.getLocation())]
                                                mag = distance(self.combatTarget.getLocation(), self.combatTarget.moveTarget)
                                                bulletMag = distance(self.agent.getLocation(), self.combatTarget.getLocation())

                                                normalizedDirection = [x/mag for x in direction]
                                                next = [m*n for m,n in zip(normalizedDirection,self.combatTarget.speed)]
                                                nextX, nextY = next

                                                bulletTime = bulletMag/20
                                                
                                                self.agent.turnToFace((targetX+ (bulletTime* nextX),targetY+(bulletTime*nextY)))
                                        else:
                                                self.agent.turnToFace(self.combatTarget.getLocation())
                                        self.agent.shoot()
                                else :                                                          # if target is dead
                                        lowestHitpoints = -1
                                        for c in self.combatants:
                                                if c.alive:
                                                        if lowestHitpoints == -1 or c.getHitpoints() < lowestHitpoints:
                                                                lowestHitpoints = c.getHitpoints()
                                                                self.combatTarget = c
                        else :                                                                  # if target is None
                                lowestHitpoints = -1
                                for c in self.combatants:
                                        if c.alive:
                                                if lowestHitpoints == -1 or c.getHitpoints() < lowestHitpoints:
                                                        lowestHitpoints = c.getHitpoints()
                                                        self.combatTarget = c
                else:                                                                           # if target is empty or unassigned
                        lowestHitpoints = -1
                        for c in self.combatants:
                                if c.alive:
                                        if lowestHitpoints == -1 or c.getHitpoints() < lowestHitpoints:
                                                lowestHitpoints = c.getHitpoints()
                                                self.combatTarget = c


                # bullet dodging
                if self.agent.canDodge:
                        for b in self.agent.getVisible():
                                if b in self.agent.world.getBullets():
                                        if b.getOwner().getTeam() != self.agent.getTeam():
                                                
                                                if b not in self.hazardousBullets:
                                                        agentLocX, agentLocY = self.agent.getLocation()
                                                        
                                                        bulletLocX, bulletLocY = b.getLocation()

                
                                                        bulletOrientationVector = (math.cos(math.radians(b.orientation)),math.sin(math.radians(b.orientation)))

                                                        bulletSpeedX, bulletSpeedY = bulletOrientationVector
                                                        bulletTrajectoryX = b.range*bulletSpeedX
                                                        bulletTrajectoryY = -b.range*bulletSpeedY
                                                        agentHitboxPlane = (-bulletTrajectoryY,bulletTrajectoryX)
                                                        negAgentHitboxPlane = (bulletTrajectoryY, - bulletTrajectoryX)
                                                        
                                                        bulletIntersection = rayTrace(b.getLocation(),(bulletLocX+bulletTrajectoryX,bulletLocY+bulletTrajectoryY),((agentLocX-bulletTrajectoryY,agentLocY+bulletTrajectoryX),(agentLocX+bulletTrajectoryY,agentLocY-bulletTrajectoryX)))


                                                        if bulletIntersection:
                                                                self.hazardousBullets.append(b)
                                                                if distance(bulletIntersection,self.agent.getLocation()) < 10:
                                                                        #dodge along (agentLocX+bulletTrajectoryY,agentLocY-bulletTrajectoryX)) or (agentLocX-bulletTrajectoryY,agentLocY+bulletTrajectoryX))
                                                                        if rayTraceWorld(self.agent.getLocation(),(agentLocX+(self.agent.getRadius()*6*bulletSpeedY),agentLocY-(self.agent.getRadius()*6*(-bulletSpeedX))),self.agent.world.getLines()) is None:
                                                                                self.agent.dodge(math.atan2(-bulletSpeedX,bulletSpeedY)*(180/math.pi))
                                                                        elif rayTraceWorld(self.agent.getLocation(),(agentLocX-(self.agent.getRadius()*6*bulletSpeedY),agentLocY+(self.agent.getRadius()*6*(-bulletSpeedX))),self.agent.world.getLines()) is None:
                                                                                self.agent.dodge(math.atan2(bulletSpeedX,-bulletSpeedY)*(180/math.pi))


                
### Full Combat Mode
###
### Minimize damage taken, maximize damage delivered

### Restore
###
### Remain at base until reserves filled
class Restore(State):
        def execute(self, delta =0):
                if self.agent.hitpoints == self.agent.getMaxHitpoints():
                        self.agent.changeState(Posse)
        
